//
//  Operation.h
//  tuber
//
//  Created by ドラッサル 亜嵐 on 2016/06/09.
//  Copyright © 2016年 ドラッサル 亜嵐. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AFNetworking.h"

@interface Operation : NSObject

@property (nonatomic, strong) AFHTTPSessionManager *manager;
@property (nonatomic, strong) AFHTTPSessionManager *managerCustom;
@property (nonatomic, strong) AFHTTPSessionManager *managerImage;
@property (nonatomic, strong) AFHTTPSessionManager *managerRaw;
@property (nonatomic, strong) AFHTTPSessionManager *managerStreamToFile;

- (void)search:(NSString*)query success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)details:(NSArray*)listDetail success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)getVideoInfo:(NSString*)urlString success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)getImage:(NSString*)urlString success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)getRaw:(NSString*)urlString
       success:(void(^)(id JSON))successHandler
       failure:(void(^)(NSError *error, id JSON))failureHandler;
- (UIImage*)getImageFromFile:(NSString*)filename;
- (void)streamToFile:(NSString*)urlString
          saveToPath:(NSString*)saveToPath
       progressBlock:(void(^)(double fractionCompleted))progressBlock
             success:(void(^)(NSString *savedTo))successHandler
             failure:(void(^)(NSError *error))failureHandler;
+ (instancetype)sharedOperation;

@end
