//
//  DBManager.h
//  SQLite3DBSample
//
//  Created by ドラッサル 亜嵐 on 2016/02/03.
//  Copyright © 2016年 ドラッサル 亜嵐. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol DBManagerDelegate
@optional
- (void)gotData:(NSString *)data;
@required
@end

@interface DBManager : NSObject
@property (nonatomic,assign) id <DBManagerDelegate> delegate;
@property (nonatomic, strong) NSMutableArray *arrColumnNames;
@property (nonatomic) int affectedRows;
@property (nonatomic) long long lastInsertedRowID;

-(NSArray *)loadDataFromDB:(NSString *)query;
-(void)executeQuery:(NSString *)query;
- (NSArray*)getVideoDataList;
- (bool)saveVideoData:(NSString *)videoId
        videoFilename:(NSString *)videoFilename
            videoItag:(NSString *)videoItag
           videoTitle:(NSString *)videoTitle
     videoDescription:(NSString *)videoDescription
        videoDuration:(NSString *)videoDuration
       videoChannelId:(NSString *)videoChannelId
    videoChannelTitle:(NSString *)videoChannelTitle
     videoPublishedAt:(NSString *)videoPublishedAt
                  raw:(NSString *)raw;
- (bool)saveVideoDataThumb:(NSString *)videoId
             videoFilename:(NSString *)videoThumb;
- (bool)deleteVideoData:(NSString *)recordId;
+ (NSString*) createDatabaseIfRequiredAtPath:(NSString*)databasePath;

+ (instancetype)sharedInstance;

@end
