//
//  NSMutableAttributedString.m
//  tuber
//
//  Created by ドラッサル 亜嵐 on 2017/07/01.
//  Copyright © 2017年 ドラッサル 亜嵐. All rights reserved.
//

#import "NSMutableAttributedString.h"

#define RGB(r, g, b) [UIColor colorWithRed:(float)r / 255.0 green:(float)g / 255.0 blue:(float)b / 255.0 alpha:1.0]
#define RGBA(r, g, b, a) [UIColor colorWithRed:(float)r / 255.0 green:(float)g / 255.0 blue:(float)b / 255.0 alpha:a]

@implementation NSMutableAttributedString (SetAsLinkSupport)

- (BOOL)setAsLink:(NSString*)textToFind linkURL:(NSString*)linkURL {
    
    NSRange foundRange = [self.mutableString rangeOfString:textToFind];
    if (foundRange.location != NSNotFound) {
        [self addAttribute:NSLinkAttributeName value:linkURL range:foundRange];
        return YES;
    }
    return NO;
}

- (NSAttributedString *)linkedStringFromFullString:(NSString *)fullString
                                    withLinkString:(NSString *)linkString
                                      andUrlString:(NSString *)urlString
                                       andFontSize:(NSInteger)fontSize
{
    NSRange range = [fullString rangeOfString:linkString options:NSLiteralSearch];
    NSMutableAttributedString *str = [[NSMutableAttributedString alloc] initWithString:fullString];
    
    NSMutableParagraphStyle *paragraphStyle = NSMutableParagraphStyle.new;
    paragraphStyle.alignment = NSTextAlignmentCenter;
    NSDictionary *attributes = @{NSForegroundColorAttributeName:RGB(0x99, 0x99, 0x99),
                                 NSFontAttributeName:[UIFont fontWithName:@"HelveticaNeue-Light" size:fontSize],
                                 NSParagraphStyleAttributeName:paragraphStyle};
    [str addAttributes:attributes range:NSMakeRange(0, [str length])];
    [str addAttribute: NSLinkAttributeName value:urlString range:range];
    
    return str;
}

@end
