//
//  FileDownloadInfo.h
//  BGTransferDemo
//
//  Created by Gabriel Theodoropoulos on 25/3/14.
//  Copyright (c) 2014 Appcoda. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FileDownloadInfo : NSObject

@property (nonatomic, strong) NSString *fileTitle;

@property (nonatomic, strong) NSString *downloadSource;

@property (nonatomic, strong) NSURLSessionDownloadTask *downloadTask;

@property (nonatomic, strong) NSData *taskResumeData;

@property (nonatomic) double downloadProgress;

@property (nonatomic) BOOL isDownloading;

@property (nonatomic) BOOL downloadComplete;

@property (nonatomic) unsigned long taskIdentifier;

@property (nonatomic, strong) NSString *destinationFilename;

- (id)initWithFileTitle:(NSString *)title
      andDownloadSource:(NSString *)source;
- (id)initWithFileTitle:(NSString *)title
     andDownloadSource:(NSString *)source
andDestinationFilename:(NSString *)filename;

@end
