//
//  Operation.h
//  tuber
//
//  Created by ドラッサル 亜嵐 on 2016/06/09.
//  Copyright © 2016年 ドラッサル 亜嵐. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AFNetworking.h"

/**
 *  The quality of YouTube videos. These values are used as keys in the `<[XCDYouTubeVideo streamURLs]>` property.
 *
 *  The constant numbers are the YouTube [itag](https://en.wikipedia.org/wiki/Talk:YouTube/Archive_22#Moved_from_YouTube#Quality_formats) values.
 */
typedef NS_ENUM(NSUInteger, YouTubeVideoQuality) {
    /**
     *  Video: 240p MPEG-4 Visual | 0.175 Mbit/s
     *  Audio: AAC | 36 kbit/s
     */
    YouTubeVideoQualitySmall240  = 36,
    
    /**
     *  Video: 360p H.264 | 0.5 Mbit/s
     *  Audio: AAC | 96 kbit/s
     */
    YouTubeVideoQualityMedium360 = 18,
    
    /**
     *  Video: 720p H.264 | 2-3 Mbit/s
     *  Audio: AAC | 192 kbit/s
     */
    YouTubeVideoQualityHD720     = 22,
};

@interface Operation : NSObject {
    NSLock* _lock;
}

@property (nonatomic, strong) AFHTTPSessionManager *manager;
@property (nonatomic, strong) AFHTTPSessionManager *managerCustom;
@property (nonatomic, strong) AFHTTPSessionManager *managerImage;
@property (nonatomic, strong) AFHTTPSessionManager *managerRaw;
@property (nonatomic, strong) AFHTTPSessionManager *managerStreamToFile;
@property bool downloadInBackgroundFlg;

- (void)startup;

- (void)search:(NSString*)query success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)details:(NSArray*)listDetail success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (NSArray *)downloadAvailableVideoQuality:(NSString *)selectedVideoId;
- (void)getVideoInfo:(NSString*)urlString success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)getImage:(NSString*)urlString success:(void(^)(id JSON))successHandler failure:(void(^)(NSError *error, id JSON))failureHandler;
- (void)getRaw:(NSString*)urlString
       success:(void(^)(id JSON))successHandler
       failure:(void(^)(NSError *error, id JSON))failureHandler;
- (UIImage*)getImageFromFile:(NSString*)filename;
- (void)streamToFile:(NSString*)urlString
          saveToPath:(NSString*)saveToPath
       progressBlock:(void(^)(double fractionCompleted))progressBlock
             success:(void(^)(NSString *savedTo))successHandler
             failure:(void(^)(NSError *error))failureHandler;
- (bool)registerVideoForDownload:(NSString *)videoId;
+ (instancetype)sharedInstance;

@end
