//
//  DBManager.h
//  SQLite3DBSample
//
//  Created by ドラッサル 亜嵐 on 2016/02/03.
//  Copyright © 2016年 ドラッサル 亜嵐. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol DBManagerDelegate
@optional
- (void)gotData:(NSString *)data;
@required
@end

@interface DBManager : NSObject
@property (nonatomic,assign) id <DBManagerDelegate> delegate;
@property (nonatomic, strong) NSMutableArray *arrColumnNames;
@property (nonatomic) int affectedRows;
@property (nonatomic) long long lastInsertedRowID;

-(NSArray *)loadDataFromDB:(NSString *)query;
- (bool)executeQuery:(NSString *)query;
- (NSArray *)getVideoDataList;
- (bool)saveVideoDataUrl:(NSString *)recordId
           videoFilename:(NSString *)videoFilenameUrl;
- (NSArray *)getVideoData:(NSString *)videoId;
- (NSString *)getRecordIdByVideoId:(NSString *)videoId
                         videoItag:(NSString *)videoItag;
- (NSString *)getRecordIdByFilename:(NSString *)filename;
- (NSString *)getVideoIdByRecordId:(NSString *)recordId;
- (NSString *)getVideoItagByRecordId:(NSString *)recordId;
- (NSString *)getVideoThumbnailUrlByRecordId:(NSString *)recordId;
- (NSString *)getVideoDataUrlByRecordId:(NSString *)recordId;
- (NSString *)getVideoDataFilenameByUrl:(NSString *)videoFilenameUrl;
- (bool)saveVideoId:(NSString *)videoId
          videoItag:(NSString *)videoItag;
- (bool)saveVideoIdWithDataUrl:(NSString *)videoId
                     videoItag:(NSString *)videoItag
              videoFilenameUrl:(NSString *)videoFilenameUrl;
- (bool)saveVideoInfo:(NSString *)recordId
           videoTitle:(NSString *)videoTitle
     videoDescription:(NSString *)videoDescription
        videoDuration:(NSString *)videoDuration
       videoChannelId:(NSString *)videoChannelId
    videoChannelTitle:(NSString *)videoChannelTitle
     videoPublishedAt:(NSString *)videoPublishedAt
        videoThumbUrl:(NSString *)videoThumbURL
                  raw:(NSString *)raw;
- (bool)saveVideoData:(NSString *)recordId
        videoFilename:(NSString *)videoFilename;
- (bool)saveVideoDataSuccess:(NSString *)recordId;
- (bool)saveVideoDataFailed:(NSString *)recordId;
- (bool)saveVideoThumb:(NSString *)recordId
         videoFilename:(NSString *)videoThumb;
- (bool)deleteVideoData:(NSString *)recordId;
- (bool)arrangeVideoData:(NSInteger)recordIdFrom recordIdTo:(NSInteger)recordIdTo;
+ (NSString*) createDatabaseIfRequiredAtPath:(NSString*)databasePath;

+ (instancetype)sharedInstance;

@end
