//
//  FirstViewController.h
//  tuber
//
//  Created by ドラッサル 亜嵐 on 2016/06/09.
//  Copyright © 2016年 ドラッサル 亜嵐. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface FirstViewController : UIViewController <UITableViewDelegate, UITableViewDataSource, UITextFieldDelegate>

@property (weak, nonatomic) IBOutlet UITextField *txtSearch;
@property (weak, nonatomic) IBOutlet UITableView *tblResult;
@property (nonatomic, weak) IBOutlet UISwitch *lowQualitySwitch;
@property (nonatomic, weak) IBOutlet UILabel *percentComplete;
@property int selectionEnabled;

/**
 *  ------------------------------------------
 *  @name Defining the preferred video quality
 *  ------------------------------------------
 */

/**
 *  The preferred order for the quality of the video to play. Plays the first match when multiple video streams are available.
 *
 *  Defaults to @[ XCDYouTubeVideoQualityHTTPLiveStreaming, @(XCDYouTubeVideoQualityHD720), @(XCDYouTubeVideoQualityMedium360), @(XCDYouTubeVideoQualitySmall240) ]
 *
 *  You should set this property right after calling the `<initWithVideoIdentifier:>` method. Setting this property to nil restores its default values.
 *
 *  @see XCDYouTubeVideoQuality
 */
@property (nonatomic, copy, null_resettable) NSArray *preferredVideoQualities;

- (void)populateResult:(NSDictionary *) result;
- (void)populateDetail:(NSDictionary *) result;

- (void)getDetail:(NSArray *) listDetail;
- (void)getVideoInfo:(NSString *) videoId;

@end

