//
//  FourthViewController.m
//  tuber
//
//  Created by ドラッサル 亜嵐 on 2017/07/01.
//  Copyright © 2017年 ドラッサル 亜嵐. All rights reserved.
//

#import "FourthViewController.h"
#import "NSMutableAttributedString.h"
#import "Operation.h"

@import AVFoundation;

@interface FourthViewController () <UIActionSheetDelegate>

@property (nonatomic, weak) IBOutlet UISwitch *playVideoInBackgroundSwitch;
@property (nonatomic, weak) IBOutlet UISwitch *downloadVideoDataInBackgroundSwitch;
@property (nonatomic, weak) IBOutlet UILabel *audioSessionCategoryLabel;
@property (nonatomic, weak) IBOutlet UILabel *versionLabel;

@end

@implementation FourthViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.

    self.playVideoInBackgroundSwitch.on = [[NSUserDefaults standardUserDefaults] boolForKey:@"PlayVideoInBackground"];
    
    //NSBundle *bundle = [NSBundle bundleWithIdentifier:@"ch.pitaya.xcdyoutubekit"];
    NSBundle *bundle = [NSBundle mainBundle];
    self.versionLabel.text = [NSString stringWithFormat:@"バージョン %@ (%@)", [bundle objectForInfoDictionaryKey:@"CFBundleShortVersionString"], [bundle objectForInfoDictionaryKey:@"CFBundleVersion"]];
    

    
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:@"I love stackoverflow!"];
    
    NSString *fullString = @"ホームページ";
    NSString *linkString = @"ホームページ";
    NSString *urlString = @"https://www.drassal.net/iosapp.php";
    
    txtHomePage.attributedText = [attributedString linkedStringFromFullString:fullString
                                                               withLinkString:linkString
                                                                 andUrlString:urlString
                                                                  andFontSize:16];
}

- (void)viewWillDisappear:(BOOL)animated {
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (IBAction) homePage:(UILabel *)sender {
    
}

- (IBAction) togglePlayVideoInBackground:(UISwitch *)sender
{
    /**
     *  `PlayVideoInBackground` is a user default used by the MediaPlayer framework which controls whether a `MPMoviePlayerController` continues playing videos while in the background.
     *
     *  In addition to the `PlayVideoInBackground` user default, background playback requires:
     *    - The `UIBackgroundModes` array (Required background modes) in the application Info.plist file must contain the `audio` element (App plays audio or streams audio/video using AirPlay).
     *    - The audio session category must be set to `AVAudioSessionCategoryPlayback`.
     *
     *  On iOS 7, changing the `PlayVideoInBackground` user default has no effect. See MPMoviePlayerController+BackgroundPlayback for a solution.
     */
    [[NSUserDefaults standardUserDefaults] setBool:self.playVideoInBackgroundSwitch.on forKey:@"PlayVideoInBackground"];
    if(self.playVideoInBackgroundSwitch.on) {
        [self setAudioSessionCategory:AVAudioSessionCategoryPlayback];
    } else {
        [self setAudioSessionCategory:AVAudioSessionCategorySoloAmbient];
    }
}

- (IBAction) selectAudioSessionCategory:(UIButton *)sender
{
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:NSLocalizedString(@"Audio Session Category", nil) delegate:self cancelButtonTitle:NSLocalizedString(@"Cancel", nil) destructiveButtonTitle:nil otherButtonTitles:NSLocalizedString(@"Solo Ambient", nil), NSLocalizedString(@"Playback", nil), nil];
    [actionSheet showFromRect:[sender frame] inView:[sender superview] animated:YES];
}

- (void) actionSheet:(UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (buttonIndex == actionSheet.cancelButtonIndex)
        return;
    
    NSString *category = @[AVAudioSessionCategorySoloAmbient, AVAudioSessionCategoryPlayback][buttonIndex];
    [[NSUserDefaults standardUserDefaults] setObject:category forKey:@"AudioSessionCategory"];
    
    NSError *error = nil;
    BOOL success = [[AVAudioSession sharedInstance] setCategory:category error:&error];
    if (success)
        self.audioSessionCategoryLabel.text = [[AVAudioSession sharedInstance] category];
    else
        NSLog(@"Audio Session Category error: %@", error);
}

- (IBAction) toggleDownloadVideoDataInBackground:(UISwitch *)sender
{
    if(self.downloadVideoDataInBackgroundSwitch.on) {
        [Operation sharedInstance].downloadInBackgroundFlg = true;
    } else {
        [Operation sharedInstance].downloadInBackgroundFlg = false;
    }
}

- (void) setAudioSessionCategory:(NSString *)audioSessionCategory {
    NSString *category = audioSessionCategory;
    [[NSUserDefaults standardUserDefaults] setObject:category forKey:@"AudioSessionCategory"];
    
    NSError *error = nil;
    BOOL success = [[AVAudioSession sharedInstance] setCategory:category error:&error];
    if (success)
        self.audioSessionCategoryLabel.text = [[AVAudioSession sharedInstance] category];
    else
        NSLog(@"Audio Session Category error: %@", error);
}

@end
